@extends('layouts.app')

@section('title', 'Create Thread | ' . $board->name)

@section('content')
<div class="forum-container">
    <div class="forum-breadcrumbs">
        <a href="{{ route('forum.index') }}">Forums</a>
        <span class="separator">/</span>
        <a href="{{ route('forum.board', $board->slug) }}">{{ $board->name }}</a>
        <span class="separator">/</span>
        <span class="current">Create Thread</span>
    </div>
    
    <div class="forum-board-header">
        <h1>Create New Thread</h1>
        <p>Start a new discussion in {{ $board->name }}</p>
    </div>
    
    <div class="forum-thread-form">
        <form action="{{ route('forum.store-thread', $board->slug) }}" method="POST">
            @csrf
            
            <div class="form-group">
                <label for="title">Thread Title</label>
                <input type="text" id="title" name="title" class="form-control @error('title') is-invalid @enderror" value="{{ old('title') }}" required>
                @error('title')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>
            
            <div class="form-group">
                <label for="content">Content</label>
                <x-bbcode-editor 
                    name="content"
                    placeholder="Write your post content here..."
                    :content="old('content')"
                    height="300px"
                />
                @error('content')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>
            
            <div class="form-actions">
                <a href="{{ route('forum.board', $board->slug) }}" class="btn btn-secondary">Cancel</a>
                <button type="submit" class="btn btn-primary">Create Thread</button>
            </div>
        </form>
    </div>
</div>
@endsection
